Ponder.registry((event) => {
    /**
     * scene with custom structure
     * 
     */
    event
        .create(["kubejs:iron_contract","kubejs:gold_contract","kubejs:diamond_contract"])
        .scene(
            "our_first_scene",
            "How to hire employees",
            "kubejs:employee",
            (scene, util) => {
                scene.showBasePlate();
                scene.world.showSection([2,1,2], Facing.DOWN);
                //let cc=util.select.layer(1);
                let cc=util.select.fromTo(new BlockPos(0,1,1),new BlockPos(4,1,1))
                //scene.rotateCameraY(90)
                scene.overlay.showOutlineWithText(cc,60).text("Customers would appear on a fixed line...")
                scene.idle(80);
                scene.rotateCameraY(180)
                scene.idle(40);

                let link = scene.world.showIndependentSection([2,4,3], Direction.DOWN);
                scene.world.moveSection(link, [0,-3,0], 0);
                scene.idle(20)
                cc=util.select.position(2,1,3)
                scene.overlay.showOutlineWithText(cc,60).text("And employees should stay on the other side")
                scene.addKeyframe();
                scene.idle(60)

                const rumia = scene.world.createEntity("youkaishomecoming:rumia", [2.5, 1.5, 3.5]);
                scene.text(80, "Right Click any creature with contract to hire employees", [2.5, 3, 3.5]).placeNearTarget();
                scene.showControls(80, [2.5, 3, 3.5], "down").rightClick().withItem("kubejs:gold_contract")
                scene.idle(80)

                link = scene.world.showIndependentSection([1,4,3], Direction.DOWN);
                scene.world.moveSection(link, [0,-3,0], 0);
                cc=util.select.position(1,1,3)
                scene.overlay.showOutlineWithText(cc,80).text("Put a container with ingridents for burgers on the left...")
                scene.addKeyframe();
                scene.idle(80)
                scene.world.hideIndependentSection(link, Direction.DOWN);
                scene.idle(20)
                scene.overlay.showOutlineWithText(cc,80).text("You may use any container you prefer")
                for(let i=1;i<=3;i++){
                    link = scene.world.showIndependentSection([1,4+i,3], Direction.DOWN);
                    scene.world.moveSection(link, [0,-3-i,0], 0);
                    scene.idle(20)
                    scene.world.hideIndependentSection(link, Direction.DOWN);
                    scene.idle(20)
                }
                link = scene.world.showIndependentSection([1,4,3], Direction.DOWN);
                scene.world.moveSection(link, [0,-3,0], 0);
                scene.idle(20)
                link = scene.world.showIndependentSection([3,4,3], Direction.DOWN);
                scene.world.moveSection(link, [0,-3,0], 0);
                scene.idle(20)
                cc=util.select.position(3,1,3)
                scene.overlay.showOutlineWithText(cc,80).text("And another container on the right for holding money...")
                scene.addKeyframe();
                scene.idle(80)
                link = scene.world.showIndependentSection([2,5,2], Direction.DOWN);
                scene.world.moveSection(link, [0,-3,0], 0);
                cc=util.select.position(2,2,2)
                scene.overlay.showOutlineWithText(cc,60).text("Your employee would start automatically make burgers")
                scene.addKeyframe();
                scene.idle(60)
                scene.text(80, "Right Click them with brass hand to switch mode.", [2.5, 3, 3.5]).placeNearTarget();
                scene.showControls(80, [2.5, 3, 3.5], "down").rightClick().withItem("create:brass_hand")
                scene.idle(80)
                scene.rotateCameraY(180)
            }
        );
    event.create(Object.keys(global.snacks).filter(key=>isNaN(key)))
    .scene(
        "selling_snacks",
        "How to sell extra products",
        "kubejs:snacks",
        (scene, util) => {
            scene.showBasePlate();
            scene.world.showSection([2, 1, 4, 6, 2, 4], Facing.DOWN);
            scene.showControls(20, [2.5, 3, 4.5], "down").rightClick().withItem("kubejs:soda_plain")
            scene.idle(20)
            scene.world.modifyBlockEntityNBT([2, 2, 4], (nbt) => {
                nbt.Items = [
                    {id:'kubejs:soda_pomegranate',Count:1},
                    {id:'kubejs:soda_plain',Count:1},
                    {id: 'collectorsreap:pomegranate_custard',Count:1},
                    {id: 'collectorsreap:limeade',Count:1}
                ];
            });
            scene.idle(20)
            scene.showControls(20, [3.5, 3, 4.5], "down").rightClick().withItem("kubejs:fries")
            scene.world.modifyBlockEntityNBT([3, 2, 4], (nbt) => {
                nbt.Items = [
                    {id:'kubejs:fries',Count:1},
                    {id:'kubejs:fried_chicken',Count:1},
                    {id:'mynethersdelight:hotdog',Count:1},
                    {id:'farmersdelight:barbecue_stick',Count:1}
                ];
            });
            scene.text(60, "Display extra products on table clothes near customers...", [3.5, 2.5, 4.5])
            scene.addKeyframe();
            scene.idle(80)
            scene.world.modifyBlockEntityNBT([2, 2, 4], (nbt) => {
                nbt.Items = [
                    {id:'kubejs:soda_pomegranate',Count:1},
                    {id: 'collectorsreap:pomegranate_custard',Count:1},
                    {id: 'collectorsreap:limeade',Count:1}
                ];
            });
            scene.world.modifyBlockEntityNBT([3, 2, 4], (nbt) => {
                nbt.Items = [
                    {id:'kubejs:fried_chicken',Count:1},
                    {id:'mynethersdelight:hotdog',Count:1},
                    {id:'farmersdelight:barbecue_stick',Count:1}
                ];
            });
            scene.particles.simple(20, "happy_villager", [3.5, 2.5, 4.5]);
            scene.particles.simple(20, "happy_villager", [2.5, 2.5, 4.5]);
            scene.text(60, "Then there's a chance to sell them along with burgers", [3.5, 2.5, 4.5])
            scene.addKeyframe();
            scene.idle(80)
            scene.text(60, "Extra products sold would affect reputation and income", [3.5, 2.5, 4.5])
            scene.idle(80)
            scene.text(60, "A customer would buy one drink and one snack at most", [3.5, 2.5, 4.5])
            scene.idle(80)
            scene.text(60, "A bigger variety of extra products would raise the chance to sell", [3.5, 2.5, 4.5])
            scene.idle(80)
            let cc=util.select.fromTo(new BlockPos(1,2,1),new BlockPos(7,2,4))
            scene.overlay.showOutlineWithText(cc,60).text("This is the detectable range where you can put table clothes").colored(PonderPalette.GREEN)
            scene.addKeyframe();
            scene.idle(80)
            scene.text(60, "Other than displaying them through right click...", [3.5, 2.5, 4.5])
            scene.idle(80)
            scene.world.showSection([2, 3, 4, 6, 3, 4], Facing.DOWN);
            scene.text(60,"...You may use any logistics to stock the table clothes.", [3.5, 4, 4.5])
            scene.addKeyframe();
            scene.idle(60)
            scene.world.hideSection([2, 3, 4, 6, 3, 4], Facing.UP)
        }

    )
});

function fadeInSection(scene, selection, movingOffset, direction, idleTicks) {
    let link = scene.world.showIndependentSection(selection, direction);
    scene.world.moveSection(link, movingOffset, 0); // 0 to instantly move
    scene.idle(idleTicks);
    scene.world.hideIndependentSection(link, direction);
    scene.idle(idleTicks);
}